const fs = require('fs');

try {
  const data = JSON.parse(fs.readFileSync('final.json', 'utf8'));

  const keys = [
    'phrase',
    'mean',
    'definition',
    'sampleSentence',
    'sampleSentenceTr',
    'synonyms',
    'pronunciation',
    'audio',
    'level',
  ];
  const stats = {};

  keys.forEach((k) => (stats[k] = 0));

  data.forEach((item) => {
    keys.forEach((k) => {
      // Check for FALSY, EMPTY STRING, or EMPTY ARRAY
      if (
        !item[k] ||
        (typeof item[k] === 'string' && item[k].trim() === '') ||
        (Array.isArray(item[k]) && item[k].length === 0)
      ) {
        stats[k]++;
      }
    });
  });

  console.log('--- Coverage Report ---');
  console.log('Total Items:', data.length);
  console.log('Missing Field Counts:');
  console.log(JSON.stringify(stats, null, 2));
} catch (e) {
  console.error('Error:', e.message);
}
